﻿var a4ImageSelector = {
    bindElements: function (container) {
        $("input.imageSelector", container).each(function () {
            var nextElement = $(this).next();
            if (!nextElement.hasClass("h-imageSelector")) {
                $(this).wrap("<div class='image-selector-container'></div>");
                $(this).after(voxco.icons.getIcon("image", "image-selector-btn h-imageSelector", { Title: sharedResources.AddImage, Large: true }));
            }
        });

        $(container).on("click", ".h-imageSelector", function () {
            var self = $(this);
            var action = (typeof a4.top().projectMenu !== "undefined") ? "MediaExternalSelector" : "MediaSelector";

            modalDialog.showWindow(a4.getAction(action, "Shared", null, { includeBaseCategory: true }), 800, 635, {
                beforeClose: function () {
                    var imageItem = $('.fancybox-iframe').contents().find('#v-selectedURL');
                    var value = imageItem.val();

                    if (value !== "" && typeof value !== "undefined") {
                        var destination = self.prev();
                        destination.val(value).attr("title", value).attr("data-url", imageItem.attr("data-url")).trigger('change');
                    }
                }
            });
        });
    },
    bindHeatMapElement: function (container) {
        $("input.imageSelectSelectorHeatMap", container).each(function () {
            var nextElement = $(this).next();
            if (!nextElement.hasClass("h-imageSelector")) {
                $(this).wrap("<div class='image-selector-container'></div>");
                $(this).after("<div class='image-selector-btn h-imageSelector h-heatMapButton'>" + sharedResources.EditImageButton + " </div>");
            }
        });
    }
}

$(document).ready(function () {
    a4ImageSelector.bindElements($('body'));
});